/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.util;

import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;

public class LimitLinesDocumentListener
implements DocumentListener {
    private final boolean isRemoveFromStart;
    private int maximumLines;
    private volatile boolean isRemoving;

    public LimitLinesDocumentListener(int maximumLines, boolean isRemoveFromStart) {
        this.setLimitLines(maximumLines);
        this.isRemoveFromStart = isRemoveFromStart;
        this.isRemoving = false;
    }

    public void setLimitLines(int maximumLines) {
        if (maximumLines < 1) {
            throw new IllegalArgumentException("Maximum lines must be greater than 0");
        }
        this.maximumLines = maximumLines;
    }

    @Override
    public void insertUpdate(final DocumentEvent e) {
        if (!this.isRemoving) {
            this.isRemoving = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LimitLinesDocumentListener.this.removeLines(e);
                }
            });
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLines(DocumentEvent e) {
        try {
            Document document = e.getDocument();
            Element root = document.getDefaultRootElement();
            int excess = root.getElementCount() - this.maximumLines;
            if (excess > 0) {
                if (this.isRemoveFromStart) {
                    this.removeFromStart(document, root, excess);
                } else {
                    this.removeFromEnd(document, root);
                }
            }
        }
        finally {
            this.isRemoving = false;
        }
    }

    private void removeFromStart(Document document, Element root, int excess) {
        Element line = root.getElement(excess - 1);
        int end = line.getEndOffset();
        try {
            document.remove(0, end);
        }
        catch (BadLocationException ble) {
            System.out.println(ble);
        }
    }

    private void removeFromEnd(Document document, Element root) {
        Element line = root.getElement(this.maximumLines);
        int start = line.getStartOffset();
        int end = root.getEndOffset();
        try {
            document.remove(start - 1, end - start);
        }
        catch (BadLocationException ble) {
            System.out.println(ble);
        }
    }
}

