/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.skcraft.concurrency.ProgressObservable;
import com.skcraft.launcher.LauncherUtils;
import com.skcraft.launcher.util.HttpFunction;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.IOUtils;

public class HttpRequest
implements Closeable,
ProgressObservable {
    private static final Logger log = Logger.getLogger(HttpRequest.class.getName());
    private static final int READ_TIMEOUT = 600000;
    private static final int READ_BUFFER_SIZE = 8192;
    private final ObjectMapper mapper = new ObjectMapper();
    private final Map<String, String> headers = new HashMap<String, String>();
    private final URL url;
    private String method;
    private String contentType;
    private byte[] body;
    private HttpURLConnection conn;
    private InputStream inputStream;
    private int redirectCount;
    private PartialDownloadInfo resumeInfo = null;
    private long contentLength = -1L;
    private long readBytes = 0L;

    private HttpRequest(String method, URL url) {
        this.method = method;
        this.url = url;
    }

    public static HttpRequest get(URL url) {
        return HttpRequest.request("GET", url);
    }

    public static HttpRequest post(URL url) {
        return HttpRequest.request("POST", url);
    }

    public static HttpRequest request(String method, URL url) {
        return new HttpRequest(method, url);
    }

    public static URL url(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private static URL reformat(URL existing) {
        try {
            URL url = new URL(existing.toString());
            URI uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
            url = uri.toURL();
            return url;
        }
        catch (MalformedURLException e) {
            log.warning("Failed to reformat url " + existing + ", using unformatted version.");
            return existing;
        }
        catch (URISyntaxException e) {
            log.warning("Failed to reformat url " + existing + ", using unformatted version.");
            return existing;
        }
    }

    public HttpRequest bodyJson(Object object) throws IOException {
        this.contentType = "application/json";
        this.body = this.mapper.writeValueAsBytes(object);
        return this;
    }

    public HttpRequest bodyForm(Form form) {
        this.contentType = "application/x-www-form-urlencoded";
        this.body = form.toString().getBytes();
        return this;
    }

    public HttpRequest header(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    public HttpRequest execute() throws IOException {
        boolean successful = false;
        try {
            if (this.conn != null) {
                throw new IllegalArgumentException("Connection already executed");
            }
            this.conn = this.runRequest(this.url);
            this.inputStream = this.conn.getResponseCode() == 200 ? this.conn.getInputStream() : this.conn.getErrorStream();
            successful = true;
        }
        finally {
            if (!successful) {
                this.close();
            }
        }
        return this;
    }

    private HttpURLConnection runRequest(URL url) throws IOException {
        if (this.redirectCount > 20) {
            throw new IOException("Too many redirects!");
        }
        HttpURLConnection conn = (HttpURLConnection)HttpRequest.reformat(url).openConnection();
        conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Java) SKMCLauncher");
        conn.setInstanceFollowRedirects(false);
        if (this.body != null) {
            conn.setRequestProperty("Content-Type", this.contentType);
            conn.setRequestProperty("Content-Length", Integer.toString(this.body.length));
            conn.setDoInput(true);
        }
        if (this.resumeInfo != null) {
            conn.setRequestProperty("Range", String.format("bytes=%d-", this.resumeInfo.currentLength));
        }
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            conn.setRequestProperty(entry.getKey(), entry.getValue());
        }
        conn.setRequestMethod(this.method);
        conn.setUseCaches(false);
        conn.setDoOutput(true);
        conn.setReadTimeout(600000);
        conn.connect();
        if (this.body != null) {
            DataOutputStream out = new DataOutputStream(conn.getOutputStream());
            out.write(this.body);
            out.flush();
            out.close();
        }
        switch (conn.getResponseCode()) {
            case 303: {
                this.method = "GET";
                this.body = null;
            }
            case 202: 
            case 301: 
            case 302: 
            case 307: 
            case 308: {
                String location = conn.getHeaderField("Location");
                location = URLDecoder.decode(location, "UTF-8");
                ++this.redirectCount;
                return this.runRequest(new URL(this.url, location));
            }
        }
        return conn;
    }

    public HttpRequest expectResponseCode(int ... codes) throws IOException {
        int responseCode = this.getResponseCode();
        for (int code : codes) {
            if (code != responseCode) continue;
            return this;
        }
        if (this.resumeInfo != null && responseCode == 206) {
            return this;
        }
        this.close();
        throw new IOException("Did not get expected response code, got " + responseCode + " for " + this.url);
    }

    public <E extends Exception> HttpRequest expectResponseCodeOr(int code, HttpFunction<HttpRequest, E> onError) throws E, IOException, InterruptedException {
        int responseCode = this.getResponseCode();
        if (code == responseCode) {
            return this;
        }
        Exception exc = (Exception)onError.call(this);
        this.close();
        throw exc;
    }

    public HttpRequest expectContentType(String ... expectedTypes) throws IOException {
        if (this.conn == null) {
            throw new IllegalArgumentException("No connection has been made!");
        }
        String contentType = this.conn.getHeaderField("Content-Type");
        for (String expectedType : expectedTypes) {
            if (!expectedType.equals(contentType)) continue;
            return this;
        }
        this.close();
        throw new IOException(String.format("Did not get expected content type '%s', instead got '%s'.", String.join((CharSequence)" | ", expectedTypes), contentType));
    }

    public int getResponseCode() throws IOException {
        if (this.conn == null) {
            throw new IllegalArgumentException("No connection has been made");
        }
        return this.conn.getResponseCode();
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public boolean isSuccessCode() throws IOException {
        int code = this.getResponseCode();
        return code >= 200 && code < 300;
    }

    public boolean isConnected() {
        return this.conn != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedResponse returnContent() throws IOException, InterruptedException {
        if (this.inputStream == null) {
            throw new IllegalArgumentException("No input stream available");
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int b = 0;
            while ((b = this.inputStream.read()) != -1) {
                LauncherUtils.checkInterrupted();
                bos.write(b);
            }
            BufferedResponse bufferedResponse = new BufferedResponse(bos.toByteArray());
            return bufferedResponse;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpRequest saveContent(File file) throws IOException, InterruptedException {
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        boolean shouldAppend = this.resumeInfo != null && this.getResponseCode() == 206;
        try {
            fos = new FileOutputStream(file, shouldAppend);
            bos = new BufferedOutputStream(fos);
            this.saveContent(bos);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bos);
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly(bos);
        IOUtils.closeQuietly(fos);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpRequest saveContent(OutputStream out) throws IOException, InterruptedException {
        try {
            long len;
            String field = this.conn.getHeaderField("Content-Length");
            if (field != null && (len = Long.parseLong(field)) >= 0L) {
                this.contentLength = len;
            }
        }
        catch (NumberFormatException field) {
            // empty catch block
        }
        try {
            BufferedInputStream bis = new BufferedInputStream(this.inputStream);
            byte[] data = new byte[8192];
            int len = 0;
            while ((len = bis.read(data, 0, 8192)) >= 0) {
                out.write(data, 0, len);
                this.readBytes += (long)len;
                LauncherUtils.checkInterrupted();
            }
            if (this.contentLength >= 0L && this.contentLength != this.readBytes) {
                throw new IOException(String.format("Connection closed with %d bytes transferred, expected %d", this.readBytes, this.contentLength));
            }
        }
        finally {
            this.close();
        }
        return this;
    }

    public Optional<PartialDownloadInfo> canRetryPartial() {
        if ("bytes".equals(this.conn.getHeaderField("Accept-Ranges"))) {
            return Optional.of(new PartialDownloadInfo(this.contentLength, this.readBytes));
        }
        return Optional.empty();
    }

    public HttpRequest setResumeInfo(PartialDownloadInfo info) {
        this.resumeInfo = info;
        return this;
    }

    public boolean isResumedRequest() {
        return this.resumeInfo != null;
    }

    @Override
    public double getProgress() {
        if (this.contentLength >= 0L) {
            return (double)this.readBytes / (double)this.contentLength;
        }
        return -1.0;
    }

    @Override
    public String getStatus() {
        return null;
    }

    @Override
    public void close() throws IOException {
        if (this.conn != null) {
            this.conn.disconnect();
        }
    }

    public URL getUrl() {
        return this.url;
    }

    public class BufferedResponse {
        private final byte[] data;

        private BufferedResponse(byte[] data) {
            this.data = data;
        }

        public byte[] asBytes() {
            return this.data;
        }

        public String asString(String encoding) throws IOException {
            return new String(this.data, encoding);
        }

        public <T> T asJson(Class<T> cls) throws IOException {
            return HttpRequest.this.mapper.readValue(this.asString("UTF-8"), cls);
        }

        public <T> T asJson(TypeReference<T> type) throws IOException {
            return HttpRequest.this.mapper.readValue(this.asString("UTF-8"), type);
        }

        public <T> T asXml(Class<T> cls) throws IOException {
            try {
                JAXBContext context = JAXBContext.newInstance(cls);
                Unmarshaller um = context.createUnmarshaller();
                return (T)um.unmarshal(new ByteArrayInputStream(this.data));
            }
            catch (JAXBException e) {
                throw new IOException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BufferedResponse saveContent(File file) throws IOException, InterruptedException {
            FileOutputStream fos = null;
            BufferedOutputStream bos = null;
            file.getParentFile().mkdirs();
            try {
                fos = new FileOutputStream(file);
                bos = new BufferedOutputStream(fos);
                this.saveContent(bos);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bos);
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
            IOUtils.closeQuietly(bos);
            IOUtils.closeQuietly(fos);
            return this;
        }

        public BufferedResponse saveContent(OutputStream out) throws IOException, InterruptedException {
            out.write(this.data);
            return this;
        }
    }

    public static class PartialDownloadInfo {
        private final long expectedLength;
        private final long currentLength;

        public PartialDownloadInfo(long expectedLength, long currentLength) {
            this.expectedLength = expectedLength;
            this.currentLength = currentLength;
        }

        public long getExpectedLength() {
            return this.expectedLength;
        }

        public long getCurrentLength() {
            return this.currentLength;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PartialDownloadInfo)) {
                return false;
            }
            PartialDownloadInfo other = (PartialDownloadInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getExpectedLength() != other.getExpectedLength()) {
                return false;
            }
            return this.getCurrentLength() == other.getCurrentLength();
        }

        protected boolean canEqual(Object other) {
            return other instanceof PartialDownloadInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $expectedLength = this.getExpectedLength();
            result = result * 59 + (int)($expectedLength >>> 32 ^ $expectedLength);
            long $currentLength = this.getCurrentLength();
            result = result * 59 + (int)($currentLength >>> 32 ^ $currentLength);
            return result;
        }

        public String toString() {
            return "HttpRequest.PartialDownloadInfo(expectedLength=" + this.getExpectedLength() + ", currentLength=" + this.getCurrentLength() + ")";
        }
    }

    public static final class Form {
        public final List<String> elements = new ArrayList<String>();

        private Form() {
        }

        public static Form form() {
            return new Form();
        }

        public Form add(String key, String value) {
            try {
                this.elements.add(URLEncoder.encode(key, "UTF-8") + "=" + URLEncoder.encode(value, "UTF-8"));
                return this;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (String element : this.elements) {
                if (first) {
                    first = false;
                } else {
                    builder.append("&");
                }
                builder.append(element);
            }
            return builder.toString();
        }
    }
}

