/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.update;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.skcraft.concurrency.ObservableFuture;
import com.skcraft.launcher.Launcher;
import com.skcraft.launcher.dialog.ProgressDialog;
import com.skcraft.launcher.selfupdate.LatestVersionInfo;
import com.skcraft.launcher.selfupdate.SelfUpdater;
import com.skcraft.launcher.selfupdate.UpdateChecker;
import com.skcraft.launcher.swing.SwingHelper;
import com.skcraft.launcher.util.SharedLocale;
import com.skcraft.launcher.util.SwingExecutor;
import java.awt.Window;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import javax.swing.event.SwingPropertyChangeSupport;

public class UpdateManager {
    private final SwingPropertyChangeSupport propertySupport = new SwingPropertyChangeSupport(this);
    private final Launcher launcher;
    private LatestVersionInfo pendingUpdate;

    public UpdateManager(Launcher launcher) {
        this.launcher = launcher;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public boolean getPendingUpdate() {
        return this.pendingUpdate != null;
    }

    public void checkForUpdate() {
        ListenableFuture<LatestVersionInfo> future = this.launcher.getExecutor().submit(new UpdateChecker(this.launcher));
        Futures.addCallback(future, new FutureCallback<LatestVersionInfo>(){

            @Override
            public void onSuccess(LatestVersionInfo result) {
                if (result != null) {
                    UpdateManager.this.requestUpdate(result);
                }
            }

            @Override
            public void onFailure(Throwable t) {
            }
        }, SwingExecutor.INSTANCE);
    }

    public void performUpdate(final Window window) {
        URL url = this.pendingUpdate.getUrl();
        if (url != null) {
            SelfUpdater downloader = new SelfUpdater(this.launcher, url);
            ObservableFuture<File> future = new ObservableFuture<File>(this.launcher.getExecutor().submit(downloader), downloader);
            Futures.addCallback(future, new FutureCallback<File>(){

                @Override
                public void onSuccess(File result) {
                    UpdateManager.this.propertySupport.firePropertyChange("pendingUpdate", true, false);
                    UpdateManager.this.pendingUpdate = null;
                    SwingHelper.showMessageDialog(window, SharedLocale.tr("launcher.selfUpdateComplete"), SharedLocale.tr("launcher.selfUpdateCompleteTitle"), null, 1);
                }

                @Override
                public void onFailure(Throwable t) {
                }
            }, SwingExecutor.INSTANCE);
            ProgressDialog.showProgress(window, future, SharedLocale.tr("launcher.selfUpdatingTitle"), SharedLocale.tr("launcher.selfUpdatingStatus"));
            SwingHelper.addErrorDialogCallback(window, future);
        } else {
            this.propertySupport.firePropertyChange("pendingUpdate", false, false);
        }
    }

    private void requestUpdate(LatestVersionInfo url) {
        this.propertySupport.firePropertyChange("pendingUpdate", this.getPendingUpdate(), url != null);
        this.pendingUpdate = url;
    }

    public SwingPropertyChangeSupport getPropertySupport() {
        return this.propertySupport;
    }
}

