/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.update;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.skcraft.launcher.AssetsRoot;
import com.skcraft.launcher.Instance;
import com.skcraft.launcher.Launcher;
import com.skcraft.launcher.LauncherException;
import com.skcraft.launcher.LauncherUtils;
import com.skcraft.launcher.dialog.FeatureSelectionDialog;
import com.skcraft.launcher.dialog.ProgressDialog;
import com.skcraft.launcher.install.FeatureCache;
import com.skcraft.launcher.install.FileMover;
import com.skcraft.launcher.install.FileVerify;
import com.skcraft.launcher.install.InstallExtras;
import com.skcraft.launcher.install.InstallLog;
import com.skcraft.launcher.install.Installer;
import com.skcraft.launcher.install.UpdateCache;
import com.skcraft.launcher.model.loader.LoaderManifest;
import com.skcraft.launcher.model.loader.LocalLoader;
import com.skcraft.launcher.model.minecraft.Asset;
import com.skcraft.launcher.model.minecraft.AssetsIndex;
import com.skcraft.launcher.model.minecraft.Library;
import com.skcraft.launcher.model.minecraft.Side;
import com.skcraft.launcher.model.minecraft.VersionManifest;
import com.skcraft.launcher.model.modpack.DownloadableFile;
import com.skcraft.launcher.model.modpack.Feature;
import com.skcraft.launcher.model.modpack.Manifest;
import com.skcraft.launcher.model.modpack.ManifestEntry;
import com.skcraft.launcher.persistence.Persistence;
import com.skcraft.launcher.util.Environment;
import com.skcraft.launcher.util.FileUtils;
import com.skcraft.launcher.util.HttpRequest;
import com.skcraft.launcher.util.SharedLocale;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import lombok.NonNull;

public abstract class BaseUpdater {
    private static final Logger log = Logger.getLogger(BaseUpdater.class.getName());
    private static final long JAR_SIZE_ESTIMATE = 0x500000L;
    private static final long LIBRARY_SIZE_ESTIMATE = 0x300000L;
    private final Launcher launcher;
    private final Environment environment = Environment.getInstance();
    private final List<Runnable> executeOnCompletion = new ArrayList<Runnable>();

    protected BaseUpdater(@NonNull Launcher launcher) {
        if (launcher == null) {
            throw new NullPointerException("launcher is marked non-null but is null");
        }
        this.launcher = launcher;
    }

    private static void writeDataFile(File path, Object object) {
        try {
            Persistence.write(path, object);
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Failed to write to " + path.getAbsolutePath() + " for object " + object.getClass().getCanonicalName(), e);
        }
    }

    protected void complete() {
        for (Runnable runnable : this.executeOnCompletion) {
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Manifest installPackage(@NonNull Installer installer, @NonNull Instance instance) throws Exception {
        List<Feature> features;
        if (installer == null) {
            throw new NullPointerException("installer is marked non-null but is null");
        }
        if (instance == null) {
            throw new NullPointerException("instance is marked non-null but is null");
        }
        final File contentDir = instance.getContentDir();
        final File logPath = new File(instance.getDir(), "install_log.json");
        final File cachePath = new File(instance.getDir(), "update_cache.json");
        final File featuresPath = new File(instance.getDir(), "features.json");
        installer.getTempDir().mkdirs();
        final InstallLog previousLog = Persistence.read(logPath, InstallLog.class);
        final InstallLog currentLog = new InstallLog();
        currentLog.setBaseDir(contentDir);
        final UpdateCache updateCache = Persistence.read(cachePath, UpdateCache.class);
        final FeatureCache featuresCache = Persistence.read(featuresPath, FeatureCache.class);
        Manifest manifest = HttpRequest.get(instance.getManifestURL()).execute().expectResponseCode(200).returnContent().saveContent(instance.getManifestPath()).asJson(Manifest.class);
        if (manifest.getMinimumVersion() > 3) {
            throw new LauncherException("Update required", SharedLocale.tr("errors.updateRequiredError"));
        }
        if (manifest.getBaseUrl() == null) {
            manifest.setBaseUrl(instance.getManifestURL());
        }
        if (!(features = manifest.getFeatures()).isEmpty()) {
            for (Feature feature : features) {
                Boolean bl = featuresCache.getSelected().get(feature.getName());
                if (bl == null) continue;
                feature.setSelected(bl);
            }
            Collections.sort(features);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    new FeatureSelectionDialog((Window)ProgressDialog.getLastDialog(), features, BaseUpdater.this).setVisible(true);
                }
            });
            Iterator<Feature> iterator = this;
            synchronized (iterator) {
                this.wait();
            }
            for (Feature feature : features) {
                featuresCache.getSelected().put(Strings.nullToEmpty(feature.getName()), feature.isSelected());
            }
        }
        HashMap<String, LocalLoader> loaders = Maps.newHashMap();
        for (Map.Entry<String, LoaderManifest> entry : manifest.getLoaders().entrySet()) {
            HashMap<String, DownloadableFile.LocalFile> localFilesMap = Maps.newHashMap();
            for (DownloadableFile file : entry.getValue().getDownloadableFiles()) {
                if (file.getSide() != Side.CLIENT) continue;
                DownloadableFile.LocalFile localFile = file.download(installer, manifest);
                localFilesMap.put(localFile.getName(), localFile);
            }
            loaders.put(entry.getKey(), new LocalLoader(entry.getValue(), localFilesMap));
        }
        InstallExtras installExtras = new InstallExtras(contentDir, loaders);
        for (ManifestEntry entry : manifest.getTasks()) {
            entry.install(installer, currentLog, updateCache, installExtras);
        }
        this.executeOnCompletion.add(new Runnable(){

            @Override
            public void run() {
                for (Map.Entry<String, Set<String>> entry : previousLog.getEntrySet()) {
                    for (String path : entry.getValue()) {
                        if (currentLog.has(path)) continue;
                        new File(contentDir, path).delete();
                    }
                }
                BaseUpdater.writeDataFile(logPath, currentLog);
                BaseUpdater.writeDataFile(cachePath, updateCache);
                BaseUpdater.writeDataFile(featuresPath, featuresCache);
            }
        });
        return manifest;
    }

    protected void installJar(@NonNull Installer installer, @NonNull VersionManifest.Artifact artifact, @NonNull File jarFile, @NonNull URL url) throws InterruptedException {
        if (installer == null) {
            throw new NullPointerException("installer is marked non-null but is null");
        }
        if (artifact == null) {
            throw new NullPointerException("artifact is marked non-null but is null");
        }
        if (jarFile == null) {
            throw new NullPointerException("jarFile is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (!jarFile.exists()) {
            long size = artifact.getSize();
            if (size <= 0L) {
                size = 0x500000L;
            }
            File tempFile = installer.getDownloader().download(url, "", size, jarFile.getName());
            installer.queue(new FileMover(tempFile, jarFile));
            if (artifact.getHash() != null) {
                installer.queue(new FileVerify(jarFile, jarFile.getName(), artifact.getHash()));
            }
            log.info("Installing " + jarFile.getName() + " from " + url);
        }
    }

    protected void installAssets(@NonNull Installer installer, @NonNull VersionManifest versionManifest, @NonNull URL indexUrl, @NonNull List<URL> sources) throws IOException, InterruptedException {
        if (installer == null) {
            throw new NullPointerException("installer is marked non-null but is null");
        }
        if (versionManifest == null) {
            throw new NullPointerException("versionManifest is marked non-null but is null");
        }
        if (indexUrl == null) {
            throw new NullPointerException("indexUrl is marked non-null but is null");
        }
        if (sources == null) {
            throw new NullPointerException("sources is marked non-null but is null");
        }
        AssetsRoot assetsRoot = this.launcher.getAssets();
        AssetsIndex index = HttpRequest.get(indexUrl).execute().expectResponseCode(200).returnContent().saveContent(assetsRoot.getIndexPath(versionManifest)).asJson(AssetsIndex.class);
        HashSet<String> downloading = new HashSet<String>();
        for (Map.Entry<String, Asset> entry : index.getObjects().entrySet()) {
            LauncherUtils.checkInterrupted();
            String hash = entry.getValue().getHash();
            String path = String.format("%s/%s", hash.subSequence(0, 2), hash);
            File targetFile = assetsRoot.getObjectPath(entry.getValue());
            if (targetFile.exists() || downloading.contains(path)) continue;
            ArrayList<URL> urls = new ArrayList<URL>();
            for (URL sourceUrl : sources) {
                try {
                    urls.add(LauncherUtils.concat(sourceUrl, path));
                }
                catch (MalformedURLException e) {
                    log.log(Level.WARNING, "Bad source URL for library: " + sourceUrl);
                }
            }
            File tempFile = installer.getDownloader().download(urls, "", (long)entry.getValue().getSize(), entry.getKey());
            installer.queue(new FileMover(tempFile, targetFile));
            log.info("Fetching " + path + " from " + urls);
            downloading.add(path);
        }
    }

    protected void installLibraries(@NonNull Installer installer, @NonNull Manifest manifest, @NonNull File librariesDir, @NonNull List<URL> sources) throws InterruptedException, IOException {
        if (installer == null) {
            throw new NullPointerException("installer is marked non-null but is null");
        }
        if (manifest == null) {
            throw new NullPointerException("manifest is marked non-null but is null");
        }
        if (librariesDir == null) {
            throw new NullPointerException("librariesDir is marked non-null but is null");
        }
        if (sources == null) {
            throw new NullPointerException("sources is marked non-null but is null");
        }
        VersionManifest versionManifest = manifest.getVersionManifest();
        Iterable<Library> allLibraries = versionManifest.getLibraries();
        for (LoaderManifest loader : manifest.getLoaders().values()) {
            allLibraries = Iterables.concat(allLibraries, loader.getLibraries());
        }
        for (Library library : allLibraries) {
            File targetFile;
            if (!library.matches(this.environment)) continue;
            LauncherUtils.checkInterrupted();
            Library.Artifact artifact = library.getArtifact(this.environment);
            String path = artifact.getPath();
            long size = artifact.getSize();
            if (size <= 0L) {
                size = 0x300000L;
            }
            if ((targetFile = new File(librariesDir, path)).exists()) continue;
            ArrayList<URL> urls = new ArrayList<URL>();
            for (URL sourceUrl : sources) {
                try {
                    urls.add(LauncherUtils.concat(sourceUrl, path));
                }
                catch (MalformedURLException e) {
                    log.log(Level.WARNING, "Bad source URL for library: " + sourceUrl);
                }
            }
            File tempFile = installer.getDownloader().download(urls, "", size, library.getName() + ".jar");
            log.info("Fetching " + path + " from " + urls);
            installer.queue(new FileMover(tempFile, targetFile));
            if (artifact.getSha1() == null) continue;
            installer.queue(new FileVerify(targetFile, library.getName(), artifact.getSha1()));
        }
        if (versionManifest.getLogging() != null) {
            VersionManifest.LoggingConfig config = versionManifest.getLogging().getClient();
            VersionManifest.Artifact file = config.getFile();
            File targetFile = new File(librariesDir, file.getId());
            InputStream embeddedConfig = Launcher.class.getResourceAsStream("logging/" + file.getId());
            if (embeddedConfig == null) {
                File tempFile = installer.getDownloader().download(HttpRequest.url(file.getUrl()), file.getHash(), (long)file.getSize(), file.getId());
                log.info("Downloading logging config " + file.getId() + " from " + file.getUrl());
                installer.queue(new FileMover(tempFile, targetFile));
            } else if (!targetFile.exists() || FileUtils.getShaHash(targetFile).equals(file.getHash())) {
                Path tempFile = installer.getTempDir().toPath().resolve(file.getId());
                Files.copy(embeddedConfig, tempFile, StandardCopyOption.REPLACE_EXISTING);
                log.info("Substituting embedded logging config " + file.getId());
                installer.queue(new FileMover(tempFile.toFile(), targetFile));
            }
        }
    }
}

