/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.swing;

import com.skcraft.launcher.swing.TextFieldPopupMenu;
import com.skcraft.launcher.util.LimitLinesDocumentListener;
import com.skcraft.launcher.util.SimpleLogFormatter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.commons.io.IOUtils;

public class MessageLog
extends JPanel {
    private static final Logger rootLogger = Logger.getLogger("");
    protected final SimpleAttributeSet defaultAttributes = new SimpleAttributeSet();
    protected final SimpleAttributeSet highlightedAttributes;
    protected final SimpleAttributeSet errorAttributes;
    protected final SimpleAttributeSet infoAttributes;
    protected final SimpleAttributeSet debugAttributes;
    private final int numLines;
    private final boolean colorEnabled;
    protected JTextComponent textComponent;
    protected Document document;
    private Handler loggerHandler;

    public MessageLog(int numLines, boolean colorEnabled) {
        this.numLines = numLines;
        this.colorEnabled = colorEnabled;
        this.highlightedAttributes = new SimpleAttributeSet();
        StyleConstants.setForeground(this.highlightedAttributes, new Color(0xFF7F00));
        this.errorAttributes = new SimpleAttributeSet();
        StyleConstants.setForeground(this.errorAttributes, new Color(0xFF0000));
        this.infoAttributes = new SimpleAttributeSet();
        this.debugAttributes = new SimpleAttributeSet();
        this.setLayout(new BorderLayout());
        this.initComponents();
    }

    private void initComponents() {
        JTextComponent text;
        if (this.colorEnabled) {
            this.textComponent = text = new JTextPane(){

                @Override
                public boolean getScrollableTracksViewportWidth() {
                    return true;
                }
            };
        } else {
            this.textComponent = text = new JTextArea();
            ((JTextArea)text).setLineWrap(true);
            ((JTextArea)text).setWrapStyleWord(true);
        }
        this.textComponent.setFont(new JLabel().getFont());
        this.textComponent.setEditable(false);
        this.textComponent.setComponentPopupMenu(TextFieldPopupMenu.INSTANCE);
        DefaultCaret caret = (DefaultCaret)this.textComponent.getCaret();
        caret.setUpdatePolicy(1);
        this.document = this.textComponent.getDocument();
        this.document.addDocumentListener(new LimitLinesDocumentListener(this.numLines, true));
        JScrollPane scrollText = new JScrollPane(this.textComponent);
        scrollText.setBorder(null);
        scrollText.setVerticalScrollBarPolicy(22);
        scrollText.setHorizontalScrollBarPolicy(31);
        this.add((Component)scrollText, "Center");
    }

    public String getPastableText() {
        String text = this.textComponent.getText().replaceAll("[\r\n]+", "\n");
        text = text.replaceAll("Session ID is [A-Fa-f0-9]+", "Session ID is [redacted]");
        return text;
    }

    public void clear() {
        this.textComponent.setText("");
    }

    public void log(final String line, AttributeSet attributes) {
        final Document d = this.document;
        final JTextComponent t = this.textComponent;
        if (this.colorEnabled && line.startsWith("(!!)")) {
            attributes = this.highlightedAttributes;
        }
        final AttributeSet a = attributes;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    int offset = d.getLength();
                    d.insertString(offset, line, a != null && MessageLog.this.colorEnabled ? a : MessageLog.this.defaultAttributes);
                    t.setCaretPosition(d.getLength());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
    }

    public ConsoleOutputStream getOutputStream() {
        return this.getOutputStream((AttributeSet)null);
    }

    public ConsoleOutputStream getOutputStream(AttributeSet attributes) {
        return new ConsoleOutputStream(attributes);
    }

    public ConsoleOutputStream getOutputStream(Color color) {
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        StyleConstants.setForeground(attributes, color);
        return this.getOutputStream(attributes);
    }

    public void consume(InputStream from) {
        this.consume(from, this.getOutputStream());
    }

    public void consume(InputStream from, Color color) {
        this.consume(from, this.getOutputStream(color));
    }

    public void consume(InputStream from, AttributeSet attributes) {
        this.consume(from, this.getOutputStream(attributes));
    }

    private void consume(InputStream from, ConsoleOutputStream outputStream) {
        final InputStream in = from;
        final PrintWriter out = new PrintWriter(outputStream, true);
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                byte[] buffer = new byte[1024];
                try {
                    int len;
                    while ((len = in.read(buffer)) != -1) {
                        String s = new String(buffer, 0, len);
                        System.out.print(s);
                        out.append(s);
                        out.flush();
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    IOUtils.closeQuietly(in);
                    IOUtils.closeQuietly(out);
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    public void registerLoggerHandler() {
        this.loggerHandler = new ConsoleLoggerHandler();
        rootLogger.addHandler(this.loggerHandler);
    }

    public void detachGlobalHandler() {
        if (this.loggerHandler != null) {
            rootLogger.removeHandler(this.loggerHandler);
            this.loggerHandler = null;
        }
    }

    public SimpleAttributeSet asDefault() {
        return this.defaultAttributes;
    }

    public SimpleAttributeSet asHighlighted() {
        return this.highlightedAttributes;
    }

    public SimpleAttributeSet asError() {
        return this.errorAttributes;
    }

    public SimpleAttributeSet asInfo() {
        return this.infoAttributes;
    }

    public SimpleAttributeSet asDebug() {
        return this.debugAttributes;
    }

    private class ConsoleOutputStream
    extends ByteArrayOutputStream {
        private final AttributeSet attributes;

        private ConsoleOutputStream(AttributeSet attributes) {
            this.attributes = attributes;
        }

        @Override
        public void flush() {
            String data = this.toString();
            if (data.length() == 0) {
                return;
            }
            MessageLog.this.log(data, this.attributes);
            this.reset();
        }
    }

    private class ConsoleLoggerHandler
    extends Handler {
        private final SimpleLogFormatter formatter = new SimpleLogFormatter();

        private ConsoleLoggerHandler() {
        }

        @Override
        public void publish(LogRecord record) {
            Level level = record.getLevel();
            Throwable t = record.getThrown();
            SimpleAttributeSet attributes = MessageLog.this.defaultAttributes;
            if (level.intValue() >= Level.WARNING.intValue()) {
                attributes = MessageLog.this.errorAttributes;
            } else if (level.intValue() < Level.INFO.intValue()) {
                attributes = MessageLog.this.debugAttributes;
            }
            MessageLog.this.log(this.formatter.format(record), attributes);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }
}

