/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.swing;

import com.skcraft.launcher.model.modpack.Feature;
import com.skcraft.launcher.swing.SwingHelper;
import com.skcraft.launcher.util.SharedLocale;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class FeatureTableModel
extends AbstractTableModel {
    private final List<Feature> features;

    public FeatureTableModel(List<Feature> features) {
        this.features = features;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 1: {
                return SharedLocale.tr("features.nameColumn");
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                this.features.get(rowIndex).setSelected((Boolean)value);
                break;
            }
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        return false;
    }

    @Override
    public int getRowCount() {
        return this.features.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.features.get(rowIndex).isSelected();
            }
            case 1: {
                Feature feature = this.features.get(rowIndex);
                return "<html>" + SwingHelper.htmlEscape(feature.getName()) + this.getAddendum(feature) + "</html>";
            }
        }
        return null;
    }

    private String getAddendum(Feature feature) {
        if (feature.getRecommendation() == null) {
            return "";
        }
        switch (feature.getRecommendation()) {
            case STARRED: {
                return " <span style=\"color: #3758DB\">" + SharedLocale.tr("features.starred") + "</span>";
            }
            case AVOID: {
                return " <span style=\"color: red\">" + SharedLocale.tr("features.avoid") + "</span>";
            }
        }
        return "";
    }
}

