/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.model.minecraft;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.skcraft.launcher.model.minecraft.FeatureList;
import com.skcraft.launcher.model.minecraft.mapper.PlatformDeserializer;
import com.skcraft.launcher.model.minecraft.mapper.PlatformSerializer;
import com.skcraft.launcher.util.Environment;
import com.skcraft.launcher.util.Platform;
import java.util.Map;
import java.util.regex.Pattern;

public class Rule {
    private Action action;
    private OS os;
    private Map<String, Boolean> features;

    private boolean doesOsMatch(Environment environment) {
        if (this.getOs() == null) {
            return true;
        }
        return this.getOs().matches(environment);
    }

    private boolean doFeaturesMatch(FeatureList match) {
        if (this.getFeatures() == null) {
            return true;
        }
        return match.doesMatch(this.features);
    }

    public boolean matches(Environment environment, FeatureList match) {
        return this.doesOsMatch(environment) && this.doFeaturesMatch(match);
    }

    @JsonIgnore
    public boolean isAllowed() {
        return this.action == Action.ALLOW;
    }

    public Action getAction() {
        return this.action;
    }

    public OS getOs() {
        return this.os;
    }

    public Map<String, Boolean> getFeatures() {
        return this.features;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public void setOs(OS os) {
        this.os = os;
    }

    public void setFeatures(Map<String, Boolean> features) {
        this.features = features;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Rule)) {
            return false;
        }
        Rule other = (Rule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Action this$action = this.getAction();
        Action other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        OS this$os = this.getOs();
        OS other$os = other.getOs();
        if (this$os == null ? other$os != null : !((Object)this$os).equals(other$os)) {
            return false;
        }
        Map<String, Boolean> this$features = this.getFeatures();
        Map<String, Boolean> other$features = other.getFeatures();
        return !(this$features == null ? other$features != null : !((Object)this$features).equals(other$features));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Rule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Action $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        OS $os = this.getOs();
        result = result * 59 + ($os == null ? 43 : ((Object)$os).hashCode());
        Map<String, Boolean> $features = this.getFeatures();
        result = result * 59 + ($features == null ? 43 : ((Object)$features).hashCode());
        return result;
    }

    public String toString() {
        return "Rule(action=" + (Object)((Object)this.getAction()) + ", os=" + this.getOs() + ", features=" + this.getFeatures() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class OS {
        private Platform platform;
        private Pattern version;

        @JsonProperty(value="name")
        @JsonDeserialize(using=PlatformDeserializer.class)
        @JsonSerialize(using=PlatformSerializer.class)
        public Platform getPlatform() {
            return this.platform;
        }

        public boolean matches(Environment environment) {
            return !(this.getPlatform() != null && !this.getPlatform().equals((Object)environment.getPlatform()) || this.getVersion() != null && !this.getVersion().matcher(environment.getPlatformVersion()).matches());
        }

        public Pattern getVersion() {
            return this.version;
        }

        public void setPlatform(Platform platform) {
            this.platform = platform;
        }

        public void setVersion(Pattern version) {
            this.version = version;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OS)) {
                return false;
            }
            OS other = (OS)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Platform this$platform = this.getPlatform();
            Platform other$platform = other.getPlatform();
            if (this$platform == null ? other$platform != null : !((Object)((Object)this$platform)).equals((Object)other$platform)) {
                return false;
            }
            Pattern this$version = this.getVersion();
            Pattern other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OS;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Platform $platform = this.getPlatform();
            result = result * 59 + ($platform == null ? 43 : ((Object)((Object)$platform)).hashCode());
            Pattern $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        public String toString() {
            return "Rule.OS(platform=" + (Object)((Object)this.getPlatform()) + ", version=" + this.getVersion() + ")";
        }
    }

    public static enum Action {
        ALLOW,
        DISALLOW;


        @JsonCreator
        public static Action fromJson(String text) {
            return Action.valueOf(text.toUpperCase());
        }

        @JsonValue
        public String toJson() {
            return this.name().toLowerCase();
        }
    }
}

