/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.model.minecraft;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.skcraft.launcher.model.minecraft.FeatureList;
import com.skcraft.launcher.model.minecraft.Rule;
import com.skcraft.launcher.util.Environment;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Library {
    private String name;
    private Downloads downloads;
    private Map<String, String> natives;
    private Extract extract;
    private List<Rule> rules;
    private String comment;
    private boolean locallyAvailable;

    public static String mavenNameToPath(String mavenName) {
        List<String> split = Splitter.on(':').splitToList(mavenName);
        int size = split.size();
        String group = split.get(0);
        String name = split.get(1);
        String version = split.get(2);
        String extension = "jar";
        String fileName = name + "-" + version;
        if (size > 3) {
            String classifier = split.get(3);
            if (classifier.indexOf("@") != -1) {
                List<String> parts = Splitter.on('@').splitToList(classifier);
                classifier = parts.get(0);
                extension = parts.get(1);
            }
            fileName = fileName + "-" + classifier;
        }
        fileName = fileName + "." + extension;
        return Joiner.on('/').join(group.replace('.', '/'), name, version, fileName);
    }

    public boolean matches(Environment environment) {
        boolean allow = false;
        if (this.getRules() != null) {
            for (Rule rule : this.getRules()) {
                if (!rule.matches(environment, FeatureList.EMPTY)) continue;
                allow = rule.isAllowed();
            }
        } else {
            allow = true;
        }
        return allow;
    }

    public String getNativeString(Environment environment) {
        if (this.getNatives() != null) {
            String nativeString;
            switch (environment.getPlatform()) {
                case LINUX: {
                    nativeString = this.getNatives().get("linux");
                    break;
                }
                case WINDOWS: {
                    nativeString = this.getNatives().get("windows");
                    break;
                }
                case MAC_OS_X: {
                    nativeString = this.getNatives().get("osx");
                    break;
                }
                default: {
                    return null;
                }
            }
            if (nativeString != null) {
                return nativeString.replace("${arch}", environment.getArchBits());
            }
        }
        return null;
    }

    public void ensureDownloadsExist() {
        if (this.getDownloads() == null) {
            this.setServerreq(true);
        }
    }

    public Artifact getArtifact(Environment environment) {
        this.ensureDownloadsExist();
        String nativeString = this.getNativeString(environment);
        if (nativeString != null) {
            if (this.getDownloads().getClassifiers() == null) {
                Artifact virtualArtifact = new Artifact();
                virtualArtifact.setUrl(this.getDownloads().getArtifact().getUrl());
                virtualArtifact.setPath(Library.mavenNameToPath(this.name + ":" + nativeString));
                return virtualArtifact;
            }
            return this.getDownloads().getClassifiers().get(nativeString);
        }
        return this.getDownloads().getArtifact();
    }

    public String getPath(Environment environment) {
        return this.getArtifact(environment).getPath();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Library library = (Library)o;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append(this.name, library.getName());
        builder.append(this.natives, library.getNatives());
        return builder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(45, 23);
        if (this.name != null) {
            builder.append(this.name);
        }
        if (this.natives != null) {
            builder.append(this.natives);
        }
        return builder.toHashCode();
    }

    public void setUrl(String url) {
        Artifact virtualArtifact = new Artifact();
        virtualArtifact.setUrl(url);
        if (this.getName() != null) {
            virtualArtifact.setPath(Library.mavenNameToPath(this.getName()));
        }
        Downloads downloads = new Downloads();
        downloads.setArtifact(virtualArtifact);
        this.setDownloads(downloads);
    }

    public void setName(String name) {
        this.name = name;
        if (this.getDownloads() != null) {
            if (this.getDownloads().getArtifact() == null) {
                return;
            }
            if (this.getDownloads().getArtifact().getPath() == null) {
                this.getDownloads().getArtifact().setPath(Library.mavenNameToPath(name));
            }
        }
    }

    public void setServerreq(boolean value) {
        if (value && this.getDownloads() == null) {
            this.setUrl("https://libraries.minecraft.net/");
        }
    }

    public String getName() {
        return this.name;
    }

    public Downloads getDownloads() {
        return this.downloads;
    }

    public Map<String, String> getNatives() {
        return this.natives;
    }

    public Extract getExtract() {
        return this.extract;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isLocallyAvailable() {
        return this.locallyAvailable;
    }

    public void setDownloads(Downloads downloads) {
        this.downloads = downloads;
    }

    public void setNatives(Map<String, String> natives) {
        this.natives = natives;
    }

    public void setExtract(Extract extract) {
        this.extract = extract;
    }

    public void setRules(List<Rule> rules) {
        this.rules = rules;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setLocallyAvailable(boolean locallyAvailable) {
        this.locallyAvailable = locallyAvailable;
    }

    public String toString() {
        return "Library(name=" + this.getName() + ", downloads=" + this.getDownloads() + ", natives=" + this.getNatives() + ", extract=" + this.getExtract() + ", rules=" + this.getRules() + ", comment=" + this.getComment() + ", locallyAvailable=" + this.isLocallyAvailable() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Downloads {
        private Artifact artifact;
        private Map<String, Artifact> classifiers;

        @JsonIgnore
        public List<Artifact> getAllArtifacts() {
            ArrayList<Artifact> artifacts = Lists.newArrayList();
            if (this.artifact != null) {
                artifacts.add(this.artifact);
            }
            if (this.classifiers != null) {
                artifacts.addAll(this.classifiers.values());
            }
            return artifacts;
        }

        public Artifact getArtifact() {
            return this.artifact;
        }

        public Map<String, Artifact> getClassifiers() {
            return this.classifiers;
        }

        public void setArtifact(Artifact artifact) {
            this.artifact = artifact;
        }

        public void setClassifiers(Map<String, Artifact> classifiers) {
            this.classifiers = classifiers;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Downloads)) {
                return false;
            }
            Downloads other = (Downloads)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Artifact this$artifact = this.getArtifact();
            Artifact other$artifact = other.getArtifact();
            if (this$artifact == null ? other$artifact != null : !((Object)this$artifact).equals(other$artifact)) {
                return false;
            }
            Map<String, Artifact> this$classifiers = this.getClassifiers();
            Map<String, Artifact> other$classifiers = other.getClassifiers();
            return !(this$classifiers == null ? other$classifiers != null : !((Object)this$classifiers).equals(other$classifiers));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Downloads;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Artifact $artifact = this.getArtifact();
            result = result * 59 + ($artifact == null ? 43 : ((Object)$artifact).hashCode());
            Map<String, Artifact> $classifiers = this.getClassifiers();
            result = result * 59 + ($classifiers == null ? 43 : ((Object)$classifiers).hashCode());
            return result;
        }

        public String toString() {
            return "Library.Downloads(artifact=" + this.getArtifact() + ", classifiers=" + this.getClassifiers() + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Artifact {
        private String path;
        private String url;
        private String sha1;
        private int size;

        public String getPath() {
            return this.path;
        }

        public String getUrl() {
            return this.url;
        }

        public String getSha1() {
            return this.sha1;
        }

        public int getSize() {
            return this.size;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setSha1(String sha1) {
            this.sha1 = sha1;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Artifact)) {
                return false;
            }
            Artifact other = (Artifact)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getSize() != other.getSize()) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            String this$sha1 = this.getSha1();
            String other$sha1 = other.getSha1();
            return !(this$sha1 == null ? other$sha1 != null : !this$sha1.equals(other$sha1));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Artifact;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSize();
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            String $sha1 = this.getSha1();
            result = result * 59 + ($sha1 == null ? 43 : $sha1.hashCode());
            return result;
        }

        public String toString() {
            return "Library.Artifact(path=" + this.getPath() + ", url=" + this.getUrl() + ", sha1=" + this.getSha1() + ", size=" + this.getSize() + ")";
        }
    }

    public static class Extract {
        private List<String> exclude;

        public List<String> getExclude() {
            return this.exclude;
        }

        public void setExclude(List<String> exclude) {
            this.exclude = exclude;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Extract)) {
                return false;
            }
            Extract other = (Extract)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$exclude = this.getExclude();
            List<String> other$exclude = other.getExclude();
            return !(this$exclude == null ? other$exclude != null : !((Object)this$exclude).equals(other$exclude));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Extract;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $exclude = this.getExclude();
            result = result * 59 + ($exclude == null ? 43 : ((Object)$exclude).hashCode());
            return result;
        }

        public String toString() {
            return "Library.Extract(exclude=" + this.getExclude() + ")";
        }
    }
}

