/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.launch.runtime;

import com.skcraft.launcher.util.EnvironmentParser;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaReleaseFile {
    private static final Logger log = Logger.getLogger(JavaReleaseFile.class.getName());
    private final Map<String, String> backingMap;

    private JavaReleaseFile(Map<String, String> releaseDetails) {
        this.backingMap = releaseDetails;
    }

    public String getVersion() {
        return this.backingMap.get("JAVA_VERSION");
    }

    public String getArch() {
        return this.backingMap.get("OS_ARCH");
    }

    public boolean isArch64Bit() {
        return this.getArch() == null || this.getArch().matches("x64|x86_64|amd64|aarch64");
    }

    public static JavaReleaseFile parseFromRelease(File javaPath) {
        File releaseFile = new File(javaPath, "release");
        if (releaseFile.exists()) {
            try {
                Map<String, String> releaseDetails = EnvironmentParser.parse(releaseFile);
                return new JavaReleaseFile(releaseDetails);
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Failed to read release file " + releaseFile.getAbsolutePath(), e);
                return null;
            }
        }
        return null;
    }
}

