/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.dialog;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.skcraft.concurrency.ObservableFuture;
import com.skcraft.concurrency.ProgressObservable;
import com.skcraft.launcher.dialog.ConsoleFrame;
import com.skcraft.launcher.swing.LinedBoxPanel;
import com.skcraft.launcher.swing.SwingHelper;
import com.skcraft.launcher.util.SharedLocale;
import com.skcraft.launcher.util.SwingExecutor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.ref.WeakReference;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class ProgressDialog
extends JDialog {
    private static final Logger log = Logger.getLogger(ProgressDialog.class.getName());
    private static WeakReference<ProgressDialog> lastDialogRef;
    private final String defaultTitle;
    private final String defaultMessage;
    private final JLabel label = new JLabel();
    private final JPanel progressPanel = new JPanel(new BorderLayout(0, 5));
    private final JPanel textAreaPanel = new JPanel(new BorderLayout());
    private final JProgressBar progressBar = new JProgressBar();
    private final LinedBoxPanel buttonsPanel = new LinedBoxPanel(true);
    private final JTextArea logText = new JTextArea();
    private final JScrollPane logScroll = new JScrollPane(this.logText);
    private final JButton detailsButton = new JButton();
    private final JButton logButton = new JButton(SharedLocale.tr("progress.viewLog"));
    private final JButton cancelButton = new JButton(SharedLocale.tr("button.cancel"));

    public ProgressDialog(Window owner, String title, String message) {
        super(owner, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.setResizable(true);
        this.initComponents();
        this.label.setText(message);
        this.defaultTitle = title;
        this.defaultMessage = message;
        this.setCompactSize();
        this.setLocationRelativeTo(owner);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                if (ProgressDialog.this.confirmCancel()) {
                    ProgressDialog.this.cancel();
                    ProgressDialog.this.dispose();
                }
            }
        });
    }

    public static void showProgress(Window owner, ObservableFuture<?> future, String title, String message) {
        ProgressDialog.showProgress(owner, future, future, title, message);
    }

    public static void showProgress(Window owner, final ListenableFuture<?> future, ProgressObservable observable, String title, String message) {
        final ProgressDialog dialog = new ProgressDialog(owner, title, message){

            @Override
            protected void cancel() {
                future.cancel(true);
            }
        };
        lastDialogRef = new WeakReference<2>(dialog);
        final Timer timer = new Timer();
        timer.scheduleAtFixedRate((TimerTask)new UpdateProgress(dialog, observable), 400L, 400L);
        Futures.addCallback(future, new FutureCallback<Object>(){

            @Override
            public void onSuccess(Object result) {
                timer.cancel();
                dialog.dispose();
            }

            @Override
            public void onFailure(Throwable t) {
                timer.cancel();
                dialog.dispose();
            }
        }, SwingExecutor.INSTANCE);
        dialog.setVisible(true);
    }

    public static ProgressDialog getLastDialog() {
        WeakReference<ProgressDialog> ref = lastDialogRef;
        if (ref != null) {
            return (ProgressDialog)ref.get();
        }
        return null;
    }

    private void setCompactSize() {
        this.detailsButton.setText(SharedLocale.tr("progress.details"));
        this.logButton.setVisible(false);
        this.setMinimumSize(new Dimension(400, 100));
        this.pack();
    }

    private void setDetailsSize() {
        this.detailsButton.setText(SharedLocale.tr("progress.less"));
        this.logButton.setVisible(true);
        this.setSize(400, 350);
    }

    private void initComponents() {
        this.progressBar.setMaximum(1000);
        this.progressBar.setMinimum(0);
        this.progressBar.setIndeterminate(true);
        this.progressBar.setPreferredSize(new Dimension(0, 18));
        this.buttonsPanel.addElement(this.detailsButton);
        this.buttonsPanel.addElement(this.logButton);
        this.buttonsPanel.addGlue();
        this.buttonsPanel.addElement(this.cancelButton);
        this.buttonsPanel.setBorder(BorderFactory.createEmptyBorder(30, 13, 13, 13));
        this.logScroll.setVerticalScrollBarPolicy(22);
        this.logText.setBackground(this.getBackground());
        this.logText.setEditable(false);
        this.logText.setLineWrap(true);
        this.logText.setWrapStyleWord(false);
        this.logText.setFont(new JLabel().getFont());
        this.progressPanel.add((Component)this.label, "North");
        this.progressPanel.setBorder(BorderFactory.createEmptyBorder(13, 13, 0, 13));
        this.progressPanel.add((Component)this.progressBar, "Center");
        this.textAreaPanel.setBorder(BorderFactory.createEmptyBorder(10, 13, 0, 13));
        this.textAreaPanel.add((Component)this.logScroll, "Center");
        this.add((Component)this.progressPanel, "North");
        this.add((Component)this.textAreaPanel, "Center");
        this.add((Component)this.buttonsPanel, "South");
        this.textAreaPanel.setVisible(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ProgressDialog.this.confirmCancel()) {
                    ProgressDialog.this.cancel();
                    ProgressDialog.this.dispose();
                }
            }
        });
        this.detailsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressDialog.this.toggleDetails();
            }
        });
        this.logButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsoleFrame.showMessages();
            }
        });
    }

    private boolean confirmCancel() {
        return SwingHelper.confirmDialog(this, SharedLocale.tr("progress.confirmCancel"), SharedLocale.tr("progress.confirmCancelTitle"));
    }

    protected void cancel() {
    }

    private void toggleDetails() {
        if (this.textAreaPanel.isVisible()) {
            this.textAreaPanel.setVisible(false);
            this.setCompactSize();
        } else {
            this.textAreaPanel.setVisible(true);
            this.setDetailsSize();
        }
        this.setLocationRelativeTo(this.getOwner());
    }

    private static class UpdateProgress
    extends TimerTask {
        private final ProgressDialog dialog;
        private final ProgressObservable observable;

        public UpdateProgress(ProgressDialog dialog, ProgressObservable observable) {
            this.dialog = dialog;
            this.observable = observable;
        }

        @Override
        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JProgressBar progressBar = dialog.progressBar;
                    JTextArea logText = dialog.logText;
                    JLabel label = dialog.label;
                    double progress = observable.getProgress();
                    if (progress >= 0.0) {
                        dialog.setTitle(SharedLocale.tr("progress.percentTitle", (double)Math.round(progress * 100.0 * 100.0) / 100.0, dialog.defaultTitle));
                        progressBar.setValue((int)(progress * 1000.0));
                        progressBar.setIndeterminate(false);
                    } else {
                        dialog.setTitle(dialog.defaultTitle);
                        progressBar.setIndeterminate(true);
                    }
                    String status = observable.getStatus();
                    if (status == null) {
                        status = SharedLocale.tr("progress.defaultStatus");
                        label.setText(dialog.defaultMessage);
                    } else {
                        int index = status.indexOf(10);
                        if (index == -1) {
                            label.setText(status);
                        } else {
                            label.setText(status.substring(0, index));
                        }
                    }
                    logText.setText(status);
                    logText.setCaretPosition(0);
                }
            });
        }
    }
}

