/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.auth.microsoft;

import com.skcraft.launcher.auth.AuthenticationException;
import com.skcraft.launcher.auth.microsoft.OauthHttpHandler;
import com.skcraft.launcher.auth.microsoft.OauthResult;
import com.skcraft.launcher.swing.SwingHelper;
import com.skcraft.launcher.util.HttpRequest;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;

public class MicrosoftWebAuthorizer {
    private static final Logger log = Logger.getLogger(MicrosoftWebAuthorizer.class.getName());
    private final String clientId;
    private String redirectUri;

    public OauthResult authorize() throws IOException, AuthenticationException, InterruptedException {
        if (Desktop.isDesktopSupported()) {
            return this.authorizeInteractive();
        }
        return null;
    }

    private OauthResult authorizeInteractive() throws IOException, AuthenticationException, InterruptedException {
        OauthHttpHandler httpHandler = new OauthHttpHandler();
        URI readyUrl = this.generateInteractiveUrl(httpHandler.getPort());
        log.info("Microsoft auth URL: " + readyUrl);
        SwingHelper.openURL(readyUrl);
        return httpHandler.await();
    }

    private URI generateInteractiveUrl(int port) throws AuthenticationException {
        URI interactive;
        this.redirectUri = "http://localhost:" + port;
        try {
            HttpRequest.Form query = HttpRequest.Form.form();
            query.add("client_id", this.clientId);
            query.add("scope", "XboxLive.signin XboxLive.offline_access");
            query.add("response_type", "code");
            query.add("redirect_uri", this.redirectUri);
            query.add("prompt", "select_account");
            interactive = new URI("https://login.microsoftonline.com/consumers/oauth2/v2.0/authorize?" + query);
        }
        catch (URISyntaxException e) {
            throw new AuthenticationException(e, "Failed to generate OAuth URL");
        }
        return interactive;
    }

    public MicrosoftWebAuthorizer(String clientId) {
        this.clientId = clientId;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }
}

