/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.auth;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.collect.Lists;
import com.skcraft.launcher.auth.SavedSession;
import com.skcraft.launcher.dialog.component.ListListenerReducer;
import com.skcraft.launcher.persistence.Scrambled;
import java.util.List;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.apache.commons.lang.RandomStringUtils;

@Scrambled(value="ACCOUNT_LIST_NOT_SECURITY!")
@JsonIgnoreProperties(ignoreUnknown=true)
public class AccountList
implements ListModel<SavedSession> {
    @JsonIgnore
    private final ListListenerReducer listeners = new ListListenerReducer();
    private List<SavedSession> accounts = Lists.newArrayList();
    private String clientId = RandomStringUtils.randomAlphanumeric(24);

    public synchronized void add(SavedSession session) {
        this.accounts.add(session);
        int index = this.accounts.size() - 1;
        this.listeners.intervalAdded(new ListDataEvent(this, 1, index, index));
    }

    public synchronized void remove(SavedSession session) {
        int index = this.accounts.indexOf(session);
        if (index > -1) {
            this.accounts.remove(index);
            this.listeners.intervalRemoved(new ListDataEvent(this, 2, index, index));
        }
    }

    public synchronized void update(SavedSession newSavedSession) {
        int index = this.accounts.indexOf(newSavedSession);
        if (index > -1) {
            this.accounts.set(index, newSavedSession);
            this.listeners.contentsChanged(new ListDataEvent(this, 0, index, index));
        } else {
            this.add(newSavedSession);
        }
    }

    @Override
    public int getSize() {
        return this.accounts.size();
    }

    @Override
    public SavedSession getElementAt(int index) {
        return this.accounts.get(index);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.listeners.addListDataListener(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.listeners.removeListDataListener(l);
    }

    public ListListenerReducer getListeners() {
        return this.listeners;
    }

    public List<SavedSession> getAccounts() {
        return this.accounts;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setAccounts(List<SavedSession> accounts) {
        this.accounts = accounts;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String toString() {
        return "AccountList(listeners=" + this.getListeners() + ", accounts=" + this.getAccounts() + ", clientId=" + this.getClientId() + ")";
    }
}

