/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.skcraft.launcher.AssetsRoot;
import com.skcraft.launcher.Configuration;
import com.skcraft.launcher.DefaultLauncherSupplier;
import com.skcraft.launcher.InstanceList;
import com.skcraft.launcher.InstanceTasks;
import com.skcraft.launcher.LauncherArguments;
import com.skcraft.launcher.LauncherUtils;
import com.skcraft.launcher.auth.AccountList;
import com.skcraft.launcher.auth.LoginService;
import com.skcraft.launcher.auth.MicrosoftLoginService;
import com.skcraft.launcher.auth.UserType;
import com.skcraft.launcher.launch.LaunchSupervisor;
import com.skcraft.launcher.model.minecraft.Library;
import com.skcraft.launcher.model.minecraft.VersionManifest;
import com.skcraft.launcher.persistence.Persistence;
import com.skcraft.launcher.swing.SwingHelper;
import com.skcraft.launcher.update.UpdateManager;
import com.skcraft.launcher.util.Environment;
import com.skcraft.launcher.util.HttpRequest;
import com.skcraft.launcher.util.SharedLocale;
import com.skcraft.launcher.util.SimpleLogFormatter;
import com.sun.management.OperatingSystemMXBean;
import java.awt.Window;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;

public final class Launcher {
    private static final Logger log = Logger.getLogger(Launcher.class.getName());
    public static final int PROTOCOL_VERSION = 3;
    private final ListeningExecutorService executor = MoreExecutors.listeningDecorator(Executors.newCachedThreadPool());
    private Supplier<Window> mainWindowSupplier = new DefaultLauncherSupplier(this);
    private final File baseDir;
    private final Properties properties;
    private final InstanceList instances;
    private final Configuration config;
    private final AccountList accounts;
    private final AssetsRoot assets;
    private final LaunchSupervisor launchSupervisor = new LaunchSupervisor(this);
    private final UpdateManager updateManager = new UpdateManager(this);
    private final InstanceTasks instanceTasks = new InstanceTasks(this);
    private final Environment env = Environment.getInstance();

    public Launcher(@NonNull File baseDir) throws IOException {
        this(baseDir, baseDir);
        if (baseDir == null) {
            throw new NullPointerException("baseDir is marked non-null but is null");
        }
    }

    public Launcher(@NonNull File baseDir, @NonNull File configDir) throws IOException {
        if (baseDir == null) {
            throw new NullPointerException("baseDir is marked non-null but is null");
        }
        if (configDir == null) {
            throw new NullPointerException("configDir is marked non-null but is null");
        }
        SharedLocale.loadBundle("com.skcraft.launcher.lang.Launcher", Locale.getDefault());
        this.baseDir = baseDir.getAbsoluteFile();
        this.properties = LauncherUtils.loadProperties(Launcher.class, "launcher.properties", "com.skcraft.launcher.propertiesFile");
        this.instances = new InstanceList(this);
        this.assets = new AssetsRoot(new File(baseDir, "assets"));
        this.config = Persistence.load(new File(configDir, "config.json"), Configuration.class);
        this.accounts = Persistence.load(new File(configDir, "accounts.dat"), AccountList.class);
        this.setDefaultConfig();
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                Launcher.this.cleanupExtractDir();
            }
        });
        this.updateManager.checkForUpdate();
    }

    public void setDefaultConfig() {
        double configMax = (double)this.config.getMaxMemory() / 1024.0;
        double suggestedMax = 2.0;
        double available = Double.MAX_VALUE;
        try {
            OperatingSystemMXBean bean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            available = (double)bean.getTotalPhysicalMemorySize() / 1024.0 / 1024.0 / 1024.0;
            suggestedMax = available <= 6.0 ? available * 0.48 : 4.0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.config.getMaxMemory() <= 0 || configMax >= available - 1.0) {
            this.config.setMaxMemory((int)(suggestedMax * 1024.0));
        }
    }

    public String getTitle() {
        return SharedLocale.tr("launcher.appTitle");
    }

    public String getVersion() {
        String version = this.getProperties().getProperty("version");
        if (version.equals("${project.version}")) {
            return "1.0.0-SNAPSHOT";
        }
        return version;
    }

    public MicrosoftLoginService getMicrosoftLogin() {
        return new MicrosoftLoginService(this.getProperties().getProperty("microsoftClientId"));
    }

    public LoginService getLoginService(UserType type) {
        return this.getMicrosoftLogin();
    }

    public File getInstancesDir() {
        return new File(this.getBaseDir(), "instances");
    }

    public File getTemporaryDir() {
        return new File(this.getBaseDir(), "temp");
    }

    public File getInstallerDir() {
        return new File(this.getTemporaryDir(), "install");
    }

    private File getExtractDir() {
        return new File(this.getTemporaryDir(), "extract");
    }

    public void cleanupExtractDir() {
        log.info("Cleaning up temporary extracted files directory...");
        final long now = System.currentTimeMillis();
        File[] dirs = this.getExtractDir().listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                try {
                    long time = Long.parseLong(pathname.getName());
                    return now - time > 3600000L;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        });
        if (dirs != null) {
            for (File dir : dirs) {
                log.info("Removing " + dir.getAbsolutePath() + "...");
                try {
                    FileUtils.deleteDirectory(dir);
                }
                catch (IOException e) {
                    log.log(Level.WARNING, "Failed to delete " + dir.getAbsolutePath(), e);
                }
            }
        }
    }

    public File createExtractDir() {
        File dir = new File(this.getExtractDir(), String.valueOf(System.currentTimeMillis()));
        dir.mkdirs();
        log.info("Created temporary directory " + dir.getAbsolutePath());
        return dir;
    }

    public File getLauncherBinariesDir() {
        return new File(this.getBaseDir(), "launcher");
    }

    public File getCommonDataDir() {
        return this.getBaseDir();
    }

    public File getLibrariesDir() {
        return new File(this.getCommonDataDir(), "libraries");
    }

    public File getLibraryFile(Library library) {
        return new File(this.getLibrariesDir(), library.getPath(this.env));
    }

    public File getVersionsDir() {
        return new File(this.getCommonDataDir(), "versions");
    }

    public File getVersionDir(String version) {
        return new File(this.getVersionsDir(), version);
    }

    public File getJarPath(VersionManifest versionManifest) {
        return new File(this.getVersionDir(versionManifest.getId()), versionManifest.getId() + ".jar");
    }

    public URL getNewsURL() {
        try {
            return HttpRequest.url(String.format(this.getProperties().getProperty("newsUrl"), URLEncoder.encode(this.getVersion(), "UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public URL getPackagesURL() {
        try {
            String key = Strings.nullToEmpty(this.getConfig().getGameKey());
            return HttpRequest.url(String.format(this.getProperties().getProperty("packageListUrl"), URLEncoder.encode(key, "UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String prop(String key) {
        return this.getProperties().getProperty(key);
    }

    public String prop(String key, String ... args) {
        return String.format(this.getProperties().getProperty(key), args);
    }

    public URL propUrl(String key) {
        return HttpRequest.url(this.prop(key));
    }

    public URL propUrl(String key, String ... args) {
        return HttpRequest.url(this.prop(key, args));
    }

    public void showLauncherWindow() {
        this.mainWindowSupplier.get().setVisible(true);
    }

    public static Launcher createFromArguments(String[] args) throws ParameterException, IOException {
        LauncherArguments options = new LauncherArguments();
        new JCommander(options).parse(args);
        Integer bsVersion = options.getBootstrapVersion();
        log.info(bsVersion != null ? "Bootstrap version " + bsVersion + " detected" : "Not bootstrapped");
        File dir = options.getDir();
        if (dir != null) {
            dir = dir.getAbsoluteFile();
            log.info("Using given base directory " + dir.getAbsolutePath());
        } else {
            dir = new File("").getAbsoluteFile();
            log.info("Using current directory " + dir.getAbsolutePath());
        }
        return new Launcher(dir);
    }

    public static void setupLogger() {
        SimpleLogFormatter.configureGlobalLogger();
    }

    public static void main(final String[] args) {
        Launcher.setupLogger();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Launcher launcher = Launcher.createFromArguments(args);
                    SwingHelper.setSwingProperties(SharedLocale.tr("launcher.appTitle", launcher.getVersion()));
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    launcher.showLauncherWindow();
                }
                catch (Throwable t) {
                    log.log(Level.WARNING, "Load failure", t);
                    SwingHelper.showErrorDialog(null, "Uh oh! The updater couldn't be opened because a problem was encountered.", "Launcher error", t);
                }
            }
        });
    }

    public ListeningExecutorService getExecutor() {
        return this.executor;
    }

    public Supplier<Window> getMainWindowSupplier() {
        return this.mainWindowSupplier;
    }

    public void setMainWindowSupplier(Supplier<Window> mainWindowSupplier) {
        this.mainWindowSupplier = mainWindowSupplier;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public InstanceList getInstances() {
        return this.instances;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public AccountList getAccounts() {
        return this.accounts;
    }

    public AssetsRoot getAssets() {
        return this.assets;
    }

    public LaunchSupervisor getLaunchSupervisor() {
        return this.launchSupervisor;
    }

    public UpdateManager getUpdateManager() {
        return this.updateManager;
    }

    public InstanceTasks getInstanceTasks() {
        return this.instanceTasks;
    }
}

